var ModalCtrl = ['$scope', '$rootScope', function($scope, $rootScope){

    $scope.showLoading = false;
    $scope.showSaving = false;
    $scope.showBackdrop = false;
    $scope.showChangeLocationAlert = false;


    $scope.progressBarAnimation = false;
    $scope.progressBarWidth = 5;

    $scope.info = {
        title: '',
        message: '',
        button: ''
    }


    $scope.$on('progressBar::width', function(event, width) {
        angular.element('.loading-modal .bar').css('width', width.toString() + '%');
        angular.element('.saving-modal .bar').css('width', width.toString() + '%');
    });

    $scope.$on('progressBarLoading::show', function(event) {
        $scope.showLoading = true;
        $scope.progressBarAnimation = true;
        $scope.showBackdrop = true;
    });

    $scope.$on('progressBarLoading::hide', function(event) {
        setTimeout(function(){
            angular.element('.loading-modal .bar').css('width', '5%');
            $scope.showLoading = false;
            $scope.showBackdrop = false;
            $scope.resetProgressBar();
            $scope.$apply();
        }, 500);
    });

    $scope.$on('progressBarSaving::show', function(event) {
        angular.element('.saving-modal .bar').css('width', '5%');
        $scope.showSaving = true;
        $scope.progressBarAnimation = true;
        $scope.showBackdrop = true;
    });

    $scope.$on('progressBarSaving::hide', function(event) {
        $scope.showSaving = false;
        $scope.showBackdrop = false;
        $scope.resetProgressBar();
    });



    $scope.$on('infoModal::open', function(event, title, message, button) {
        $scope.info = {
            title: title,
            message: message,
            button: button || null
        }
        $scope.showBackdrop = true;
        $scope.showInfo = true;
    });

    $scope.closeInfoModal = function(){
        $scope.showBackdrop = false;
        $scope.showInfo = false;
    }


    $scope.progresBarChange = setInterval(function(){
        if($scope.progressBarAnimation)
        {
            if($scope.progressBarWidth > 100)
            {
                $scope.progressBarWidth = 0;
            }
            $scope.progressBarWidth += 5;

            $scope.$broadcast('progressBar::width', $scope.progressBarWidth);
        }
    }, 500);


    $scope.resetProgressBar = function(){
        $scope.progressBarWidth = 5;
        $scope.progressBarAnimation = false;
    }





    $scope.hideGoLocationAlert = function(){
        $scope.showChangeLocationAlert = false;
        $scope.showBackdrop = false;
    }



    $scope.$on('changeLocationAlert::show', function(event){
        $scope.showChangeLocationAlert = true;
        $scope.showBackdrop = true;
    });

    $scope.$on('changeLocationAlert::hide', function(event){
        $scope.hideGoLocationAlert();
    });
}]